{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 25.03.98 - 20:30:26 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
{$IFDEF WIN32}
  Windows,
{$ELSE}
  WinTypes,
  WinProcs,
{$ENDIF}
  Messages,
  SysUtils,
  Classes,
  Forms,
  Dialogs,
  StdCtrls,
  ExtCtrls,
  Controls,
  MMSystem,
  MMACMDlg,
  MMWavOut,
  MMRingBf,
  MMConect,
  MMDSPObj,
  MMWavIn,
  MMObj,
  MMDesign,
  MMSlider,
  MMDIBCv,
  MMLevel,
  MMButton,
  MMGauge, MMHook;
  
type
  TForm1 = class(TForm)
    MMDesigner1: TMMDesigner;
    WaveIn1: TMMWaveIn;
    MMConnector1: TMMConnector;
    RingBuffer1: TMMRingBuffer;
    WaveOut1: TMMWaveOut;
    MMConnector2: TMMConnector;
    Timer1: TTimer;
    MMACM1: TMMACM;
    Panel6: TPanel;
    Panel1: TPanel;
    Panel3: TPanel;
    btnStop: TMMSpeedButton;
    btnRecord: TMMSpeedButton;
    btnPlay: TMMSpeedButton;
    btnPause: TMMSpeedButton;
    Panel4: TPanel;
    MMLevel1: TMMLevel;
    MMLevel2: TMMLevel;
    btnFormat: TMMSpeedButton;
    btnClear: TMMSpeedButton;
    Panel5: TPanel;
    EventMemo: TMemo;
    Panel7: TPanel;
    Label1: TLabel;
    slVolume: TMMSlider;
    ProgressBar1: TMMGauge;
    procedure btnStopClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure WaveIn1Stop(Sender: TObject);
    procedure btnRecordClick(Sender: TObject);
    procedure WaveIn1Start(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure WaveIn1BufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
    procedure btnPlayClick(Sender: TObject);
    procedure btnPauseClick(Sender: TObject);
    procedure WaveOut1BufferLoad(Sender: TObject; lpWaveHdr: PWaveHdr;
                                 var MoreBuffers: Boolean);
    procedure WaveOut1Start(Sender: TObject);
    procedure WaveOut1Stop(Sender: TObject);
    procedure WaveOut1Pause(Sender: TObject);
    procedure WaveOut1Restart(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure btnFormatClick(Sender: TObject);
    procedure btnClearClick(Sender: TObject);
    procedure slVolumeChange(Sender: TObject);
    procedure WaveIn1Open(Sender: TObject);
    procedure WaveIn1Close(Sender: TObject);
    procedure WaveOut1Open(Sender: TObject);
    procedure WaveOut1Close(Sender: TObject);
  private
    BufferCounter: Longint;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{------------------------------------------------------------------------}
{ Demonstrates the manual handling of TMMRingbuffer for half duplex      }
{ wave input and output in different formats                             }
{------------------------------------------------------------------------}

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.FormCreate(Sender: TObject);
var
   Volume: Longint;

begin
   ProgressBar1.MaxValue := RingBuffer1.NumBuffers;
   RingBuffer1.Open;

   { get the initial volume }
   WaveOutGetVolume(0,@Volume);
   slVolume.Position := HiWord(Volume) div 655;
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   RingBuffer1.Close;
   WaveIn1.Close;
   WaveOut1.Close;
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.btnRecordClick(Sender: TObject);
begin
   { try to start playing }
   try
      if not (wisRecord in WaveIn1.State) then
      begin
         BufferCounter := 0;
         RingBuffer1.Clear; { clear the ringbuffer first }
         WaveIn1.Start;     { now start recording        }
      end;

      btnRecord.Down := True;

   except
      btnRecord.Down := False;
      raise
   end;
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.btnPlayClick(Sender: TObject);
begin
   try
      if (wosPause in WaveOut1.State)and (wosPlay in WaveOut1.State) then
          WaveOut1.Restart
      else if not (wosPlay in WaveOut1.State) then
      begin
          { first set the right WaveFormat for output }
          BufferCounter := 0;
          Waveout1.PWaveFormat := WaveIn1.PWaveFormat;
          WaveOut1.Start;
      end;

      btnPlay.Down := True;

   except
      btnPlay.Down := False;
      raise
   end;
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.btnStopClick(Sender: TObject);
begin
   { stop recording or playing }
   WaveIn1.Close;
   WaveOut1.Close;
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.btnPauseClick(Sender: TObject);
begin
   try
      if not (wosPause in WaveOut1.State) then WaveOut1.Pause
      else if (wosPlay in WaveOut1.State) then WaveOut1.Restart
      else WaveOut1.Stop;

   except
      btnPause.Down := False;
      raise;
   end;
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.WaveIn1Open(Sender: TObject);
begin
   EventMemo.Lines.Add('WaveIn: Opened');
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.WaveIn1Close(Sender: TObject);
begin
   EventMemo.Lines.Add('WaveIn: Closed');
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.WaveIn1Start(Sender: TObject);
begin
   { recording succesfully started }
   Timer1.Enabled := True;

   btnStop.Enabled := True;
   btnPlay.Enabled := False;
   btnFormat.Enabled := False;

   EventMemo.Lines.Add('WaveIn: Started');
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.WaveIn1Stop(Sender: TObject);
begin
   { recording succesfully stopped }
   Timer1.Enabled := False;

   btnStop.Enabled := False;
   btnRecord.Down := False;
   btnPlay.Enabled := RingBuffer1.QueueCount > 0;
   btnFormat.Enabled := True;

   EventMemo.Lines.Add('WaveIn: Stopped');

   { close the device finally }
   WaveIn1.Close;
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.WaveOut1Open(Sender: TObject);
begin
   EventMemo.Lines.Add('WaveOut: Opened');
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.WaveOut1Close(Sender: TObject);
begin
   EventMemo.Lines.Add('WaveOut: Closed');
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.WaveOut1Start(Sender: TObject);
begin
   { playing succesfully started }
   Timer1.Enabled := True;

   btnRecord.Enabled := False;
   btnStop.Enabled := True;
   btnPause.Enabled := True;
   btnFormat.Enabled := False;

   slVolume.Enabled := True;

   EventMemo.Lines.Add('WaveOut: Started');
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.WaveOut1Pause(Sender: TObject);
begin
   btnPause.Down := True;
   EventMemo.Lines.Add('WaveOut: Paused');
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.WaveOut1Restart(Sender: TObject);
begin
   btnPause.Down := False;
   EventMemo.Lines.Add('WaveOut: Restarted');
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.WaveOut1Stop(Sender: TObject);
begin
   { playing succesfully stopped }
   btnPlay.Down := False;
   btnStop.Enabled := False;
   btnPause.Enabled := False;
   btnRecord.Enabled := True;
   btnFormat.Enabled := True;
   btnPlay.Enabled := RingBuffer1.QueueCount > 0;

   Timer1.Enabled := False;
   slVolume.Enabled := False;

   EventMemo.Lines.Add('WaveOut: Stopped');

   { close the device finally }
   WaveOut1.Close;
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.WaveIn1BufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
begin
   inc(BufferCounter);

   { the input has some data so put in the queue }
   with lpWaveHdr^ do
   RingBuffer1.PutBuffer(lpData,dwBytesRecorded,BufferCounter,0);

   EventMemo.Lines.Add('WaveIn: Buffer '+IntToStr(BufferCounter)+' Recorded');
   if EventMemo.Lines.Count > 500 then EventMemo.Clear;
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.WaveOut1BufferLoad(Sender: TObject; lpWaveHdr: PWaveHdr;
                                    var MoreBuffers: Boolean);
var
   {$IFDEF WIN32}
   Dummy: DWORD;
   {$ELSE}
   Dummy: Longint;
   {$ENDIF}
begin
   { the output needs some data so try to get it }
   with lpWaveHdr^ do
   begin
      dwBytesRecorded := dwBufferLength;
      RingBuffer1.GetBuffer(lpData,dwBytesRecorded,dwUser,Dummy);
   end;
   MoreBuffers := not RingBuffer1.Empty;

   inc(BufferCounter);
   EventMemo.Lines.Add('WaveOut: Play Buffer '+IntToStr(lpWaveHdr^.dwUser));
   if EventMemo.Lines.Count > 500 then EventMemo.Clear;
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.Timer1Timer(Sender: TObject);
begin
   ProgressBar1.Progress := RingBuffer1.QueueCount;
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.btnClearClick(Sender: TObject);
begin
   BufferCounter := 0;
   ProgressBar1.Progress := 0;
   RingBuffer1.Clear;
   EventMemo.Clear;
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.btnFormatClick(Sender: TObject);
begin
   if MMACM1.ACMPresent then
   begin
      { we give the WaveIn format as preset }
      if MMACM1.ChooseFormat(WaveIn1.PWaveFormat,'Select Format') then
      begin
         WaveIn1.PWaveFormat := MMACM1.PWaveFormat;
      end;
   end;
end;

{-- TForm1 --------------------------------------------------------------}
procedure TForm1.slVolumeChange(Sender: TObject);
var
   Volume: Longint;
begin
   if (wosOpen in WaveOut1.State) then
   begin
      Volume := (slVolume.Position)*655;
      WaveOutSetVolume(WaveOut1.Handle,(Volume shl 16) + Volume);
   end;
end;

end.
